<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Blockli\Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Status for Blockli posts
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_blockli_post_status( ) {

    $post_status_options = array();

    $statuses = get_post_statuses();

    foreach( $statuses as $post_status => $post_status_label ) {
        /* translators: %1$s: Post status key (draft, pending). %2$s: Post status label (Draft, Pending Review). */
        $post_status_options[] = sprintf( __( '<code>%1$s</code> for %2$s', 'automatorwp-pro' ), $post_status, $post_status_label );
    }

    return $post_status_options;

}
